#!/bin/bash
echo "========================================================="
echo "Uberlogger firmware updater"
echo "(c) 2024 Tecnion Technologies"
echo "========================================================="
echo ""
echo "Steps to update:"
echo "1) Connect Uberlogger to USB port on your pc and do NOT use a USB hub in between. Turn on the Uberlogger so that the Uberlogger green LED turns on."
echo "2) Hold the mode button pressed, and briefly press the reset button while holding."
echo "   The green LED should turn off. Release all buttons; the green LED should remain off. The logger is now in firmware update mode."
echo "3) Press [ENTER] to start flashing."
echo "4) The updater will search for the correct COM-port, and might try them all. Just have some patience."
echo ""
echo "Warning: do not disconnect the module from USB power or from your computer while updating"
echo ""
echo ""
read -p "Press [ENTER] to continue..." </dev/tty
if ! which esptool.py &> /dev/null; then
    echo "Note: esptool.py not found. Installing..."
    pip install esptool
fi
echo "Updating firmware..."
esptool.py --chip esp32s2 --baud 921600 --before usb_reset --after hard_reset write_flash --flash_mode dio --flash_freq 80m --flash_size 4MB 0x0000 ./firmware.bin
echo "Done."
